
clear
cap log close
set more off
set type double
set scheme s1color
pause on

log using "${log}05 Figure 1.log", replace

* Import data
import excel using "${CE}Figure 1 with FJS consumption.xlsx", sheet("Figure 1 Data") firstrow clear 

keep if _n >= 14
destring Year, replace
assert Year >= 1990 & Year <= 2018


for var HistoricalSPMPovertyRate FJS2015Consumption : replace X = X * 100

twoway ///
(line OfficialIncomePovertyCPIU Year, color(red)) ///
(line FJS2015Consumption Year, color(green)) ///
(line HistoricalSPMPovertyRate Year, color(blue)), ///
title("Figure 1: Official, SPM, and Consumption Poverty Rates, 1990–2018" " ", size(11pt))  ytitle("Poverty Rate (%)" " ") ylabel(,format(%3.0fc) labsize(small) angle(0)) xtitle("") xlabel(,labsize(small)) ///
legend(label(1  "Official (CPI-U)")  label(2 "Consumption (Fisher et al., 2015)") label(3 "SPM") size(small)) ///
note("Notes: Consumption rate is anchored to 2015 Official threshold.", size(vsmall) span) ///
caption("Sources: U.S. Census Bureau (2021), Columbia Center for Poverty and Social Policy, Fisher et al. (2015).", size(vsmall) span) ///
saving("${outgraph}05 Official, SPM, and Consumption Poverty Rates (Figure 1 C).gph",replace)
graph export "${outgraph}05 Official, SPM, and Consumption Poverty Rates (Figure 1 C).pdf",replace

twoway ///
(line OfficialIncomePovertyCPIU Year, color(gray)) ///
(line FJS2015Consumption Year, color(gray) lpattern(dash)) ///
(line HistoricalSPMPovertyRate Year, color(gray) lpattern(shortdash_dot)), ///
title("Figure 1: Official, SPM, and Consumption Poverty Rates, 1990–2018" " ", size(11pt))  ytitle("Poverty Rate (%)" " ") ylabel(,format(%3.0fc) labsize(small) angle(0)) xtitle("") xlabel(,labsize(small)) ///
legend(label(1  "Official (CPI-U)")  label(2 "Consumption (Fisher et al., 2015)") label(3 "SPM") size(small)) ///
note("Notes: Consumption rate is anchored to 2015 Official threshold.", size(vsmall) span) ///
caption("Sources: U.S. Census Bureau (2021), Columbia Center for Poverty and Social Policy, Fisher et al. (2015).", size(vsmall) span) ///
saving("${outgraph}05 Official, SPM, and Consumption Poverty Rates (Figure 1 BW).gph",replace)
graph export "${outgraph}05 Official, SPM, and Consumption Poverty Rates (Figure 1 BW).pdf",replace


log close

set scheme s2color

* EOF 
